/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.python.core.AllFunction;
import org.python.core.AnyFunction;
import org.python.core.BuiltinFunctions;
import org.python.core.CompileFunction;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.ImportFunction;
import org.python.core.MaxFunction;
import org.python.core.MinFunction;
import org.python.core.OpenFunction;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyBaseCode;
import org.python.core.PyBaseString;
import org.python.core.PyBoolean;
import org.python.core.PyCallIter;
import org.python.core.PyClassMethod;
import org.python.core.PyCode;
import org.python.core.PyComplex;
import org.python.core.PyDictionary;
import org.python.core.PyEnumerate;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyFrame;
import org.python.core.PyFrozenSet;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyProperty;
import org.python.core.PyReversedIterator;
import org.python.core.PySet;
import org.python.core.PySlice;
import org.python.core.PyStaticMethod;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySuper;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.PyXRange;
import org.python.core.RoundFunction;
import org.python.core.SortedFunction;
import org.python.core.imp;
import org.python.core.util.RelativeFile;

public class __builtin__ {
    private static final PyStringMap internedStrings = new PyStringMap();
    public static PyString __doc__zip = new PyString("zip(seq1 [, seq2 [...]]) -> [(seq1[0], seq2[0] ...), (...)]\n\nReturn a list of tuples, where each tuple contains the i-th element\nfrom each of the argument sequences.  The returned list is\ntruncated in length to the length of the shortest argument sequence.");

    public static void fillWithBuiltins(PyObject pyObject) {
        pyObject.__setitem__("object", (PyObject)PyObject.TYPE);
        pyObject.__setitem__("type", (PyObject)PyType.TYPE);
        pyObject.__setitem__("bool", (PyObject)PyBoolean.TYPE);
        pyObject.__setitem__("int", (PyObject)PyInteger.TYPE);
        pyObject.__setitem__("enumerate", (PyObject)PyEnumerate.TYPE);
        pyObject.__setitem__("float", (PyObject)PyFloat.TYPE);
        pyObject.__setitem__("long", (PyObject)PyLong.TYPE);
        pyObject.__setitem__("complex", (PyObject)PyComplex.TYPE);
        pyObject.__setitem__("dict", (PyObject)PyDictionary.TYPE);
        pyObject.__setitem__("list", (PyObject)PyList.TYPE);
        pyObject.__setitem__("tuple", (PyObject)PyTuple.TYPE);
        pyObject.__setitem__("set", (PyObject)PySet.TYPE);
        pyObject.__setitem__("frozenset", (PyObject)PyFrozenSet.TYPE);
        pyObject.__setitem__("property", (PyObject)PyProperty.TYPE);
        pyObject.__setitem__("staticmethod", (PyObject)PyStaticMethod.TYPE);
        pyObject.__setitem__("classmethod", (PyObject)PyClassMethod.TYPE);
        pyObject.__setitem__("super", (PyObject)PySuper.TYPE);
        pyObject.__setitem__("str", (PyObject)PyString.TYPE);
        pyObject.__setitem__("unicode", (PyObject)PyUnicode.TYPE);
        pyObject.__setitem__("basestring", (PyObject)PyBaseString.TYPE);
        pyObject.__setitem__("file", (PyObject)PyFile.TYPE);
        pyObject.__setitem__("slice", (PyObject)PySlice.TYPE);
        pyObject.__setitem__("xrange", (PyObject)PyXRange.TYPE);
        pyObject.__setitem__("None", Py.None);
        pyObject.__setitem__("NotImplemented", Py.NotImplemented);
        pyObject.__setitem__("Ellipsis", Py.Ellipsis);
        pyObject.__setitem__("True", (PyObject)Py.True);
        pyObject.__setitem__("False", (PyObject)Py.False);
        pyObject.__setitem__("__debug__", (PyObject)Py.One);
        pyObject.__setitem__("abs", (PyObject)new BuiltinFunctions("abs", 7, 1));
        pyObject.__setitem__("apply", (PyObject)new BuiltinFunctions("apply", 9, 1, 3));
        pyObject.__setitem__("callable", (PyObject)new BuiltinFunctions("callable", 14, 1));
        pyObject.__setitem__("coerce", (PyObject)new BuiltinFunctions("coerce", 13, 2));
        pyObject.__setitem__("chr", (PyObject)new BuiltinFunctions("chr", 0, 1));
        pyObject.__setitem__("cmp", (PyObject)new BuiltinFunctions("cmp", 6, 2));
        pyObject.__setitem__("globals", (PyObject)new BuiltinFunctions("globals", 4, 0));
        pyObject.__setitem__("hash", (PyObject)new BuiltinFunctions("hash", 5, 1));
        pyObject.__setitem__("id", (PyObject)new BuiltinFunctions("id", 11, 1));
        pyObject.__setitem__("isinstance", (PyObject)new BuiltinFunctions("isinstance", 10, 2));
        pyObject.__setitem__("len", (PyObject)new BuiltinFunctions("len", 1, 1));
        pyObject.__setitem__("ord", (PyObject)new BuiltinFunctions("ord", 3, 1));
        pyObject.__setitem__("range", (PyObject)new BuiltinFunctions("range", 2, 1, 3));
        pyObject.__setitem__("sum", (PyObject)new BuiltinFunctions("sum", 12, 1, 2));
        pyObject.__setitem__("unichr", (PyObject)new BuiltinFunctions("unichr", 6, 1));
        pyObject.__setitem__("delattr", (PyObject)new BuiltinFunctions("delattr", 15, 2));
        pyObject.__setitem__("dir", (PyObject)new BuiltinFunctions("dir", 16, 0, 1));
        pyObject.__setitem__("divmod", (PyObject)new BuiltinFunctions("divmod", 17, 2));
        pyObject.__setitem__("eval", (PyObject)new BuiltinFunctions("eval", 18, 1, 3));
        pyObject.__setitem__("execfile", (PyObject)new BuiltinFunctions("execfile", 19, 1, 3));
        pyObject.__setitem__("filter", (PyObject)new BuiltinFunctions("filter", 20, 2));
        pyObject.__setitem__("getattr", (PyObject)new BuiltinFunctions("getattr", 21, 2, 3));
        pyObject.__setitem__("hasattr", (PyObject)new BuiltinFunctions("hasattr", 22, 2));
        pyObject.__setitem__("hex", (PyObject)new BuiltinFunctions("hex", 23, 1));
        pyObject.__setitem__("input", (PyObject)new BuiltinFunctions("input", 24, 0, 1));
        pyObject.__setitem__("intern", (PyObject)new BuiltinFunctions("intern", 25, 1));
        pyObject.__setitem__("issubclass", (PyObject)new BuiltinFunctions("issubclass", 26, 2));
        pyObject.__setitem__("iter", (PyObject)new BuiltinFunctions("iter", 27, 1, 2));
        pyObject.__setitem__("locals", (PyObject)new BuiltinFunctions("locals", 28, 0));
        pyObject.__setitem__("map", (PyObject)new BuiltinFunctions("map", 29, 2, -1));
        pyObject.__setitem__("max", (PyObject)new MaxFunction());
        pyObject.__setitem__("min", (PyObject)new MinFunction());
        pyObject.__setitem__("oct", (PyObject)new BuiltinFunctions("oct", 32, 1));
        pyObject.__setitem__("pow", (PyObject)new BuiltinFunctions("pow", 33, 2, 3));
        pyObject.__setitem__("raw_input", (PyObject)new BuiltinFunctions("raw_input", 34, 0, 1));
        pyObject.__setitem__("reduce", (PyObject)new BuiltinFunctions("reduce", 35, 2, 3));
        pyObject.__setitem__("reload", (PyObject)new BuiltinFunctions("reload", 36, 1));
        pyObject.__setitem__("repr", (PyObject)new BuiltinFunctions("repr", 37, 1));
        pyObject.__setitem__("round", (PyObject)new RoundFunction());
        pyObject.__setitem__("setattr", (PyObject)new BuiltinFunctions("setattr", 39, 3));
        pyObject.__setitem__("vars", (PyObject)new BuiltinFunctions("vars", 41, 0, 1));
        pyObject.__setitem__("zip", (PyObject)new BuiltinFunctions("zip", 43, 0, -1));
        pyObject.__setitem__("compile", (PyObject)new CompileFunction());
        pyObject.__setitem__("open", (PyObject)new OpenFunction());
        pyObject.__setitem__("reversed", (PyObject)new BuiltinFunctions("reversed", 45, 1));
        pyObject.__setitem__("__import__", (PyObject)new ImportFunction());
        pyObject.__setitem__("sorted", (PyObject)new SortedFunction());
        pyObject.__setitem__("all", (PyObject)new AllFunction());
        pyObject.__setitem__("any", (PyObject)new AnyFunction());
    }

    public static PyObject abs(PyObject pyObject) {
        return pyObject.__abs__();
    }

    public static PyObject apply(PyObject pyObject) {
        return pyObject.__call__();
    }

    public static PyObject apply(PyObject pyObject, PyObject pyObject2) {
        return pyObject.__call__(Py.make_array(pyObject2));
    }

    public static PyObject apply(PyObject pyObject, PyObject pyObject2, PyDictionary pyDictionary) {
        ConcurrentMap<PyObject, PyObject> concurrentMap = pyDictionary.getMap();
        if (concurrentMap.size() > 0) {
            Iterator iterator = concurrentMap.keySet().iterator();
            Iterator iterator2 = concurrentMap.values().iterator();
            int n = concurrentMap.size();
            String[] stringArray = new String[n];
            PyObject[] pyObjectArray = Py.make_array(pyObject2);
            PyObject[] pyObjectArray2 = new PyObject[n + pyObjectArray.length];
            System.arraycopy(pyObjectArray, 0, pyObjectArray2, 0, pyObjectArray.length);
            int n2 = pyObjectArray.length;
            for (int i = 0; i < n; ++i) {
                PyObject pyObject3 = (PyObject)iterator.next();
                if (pyObject3.getClass() != PyString.class) {
                    throw Py.TypeError(String.format("keywords must be strings", new Object[0]));
                }
                stringArray[i] = ((PyString)pyObject3).internedString();
                pyObjectArray2[i + n2] = (PyObject)iterator2.next();
            }
            return pyObject.__call__(pyObjectArray2, stringArray);
        }
        return __builtin__.apply(pyObject, pyObject2);
    }

    public static boolean callable(PyObject pyObject) {
        return pyObject.isCallable();
    }

    public static int unichr(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw Py.ValueError("unichr() arg not in range(0x110000)");
        }
        return n;
    }

    public static char chr(int n) {
        if (n < 0 || n > 255) {
            throw Py.ValueError("chr() arg not in range(256)");
        }
        return (char)n;
    }

    public static int cmp(PyObject pyObject, PyObject pyObject2) {
        return pyObject._cmp(pyObject2);
    }

    public static PyTuple coerce(PyObject pyObject, PyObject pyObject2) {
        PyObject[] pyObjectArray = pyObject._coerce(pyObject2);
        if (pyObjectArray != null) {
            return new PyTuple(pyObjectArray);
        }
        throw Py.TypeError("number coercion failed");
    }

    public static void delattr(PyObject pyObject, PyObject pyObject2) {
        pyObject.__delattr__(__builtin__.asName(pyObject2, "delattr"));
    }

    public static PyObject dir(PyObject pyObject) {
        PyList pyList = (PyList)pyObject.__dir__();
        pyList.sort();
        return pyList;
    }

    public static PyObject dir() {
        PyList pyList;
        PyObject pyObject = __builtin__.locals();
        PyObject pyObject2 = pyObject.invoke("keys");
        try {
            pyList = (PyList)pyObject2;
        }
        catch (ClassCastException classCastException) {
            throw Py.TypeError(String.format("Expected keys() to be a list, not '%s'", pyObject2.getType().fastGetName()));
        }
        pyList.sort();
        return pyList;
    }

    public static PyObject divmod(PyObject pyObject, PyObject pyObject2) {
        return pyObject._divmod(pyObject2);
    }

    private static boolean isMappingType(PyObject pyObject) {
        return pyObject == null || pyObject == Py.None || pyObject.isMappingType();
    }

    private static void verify_mappings(PyObject pyObject, PyObject pyObject2) {
        if (!__builtin__.isMappingType(pyObject)) {
            throw Py.TypeError("globals must be a mapping");
        }
        if (!__builtin__.isMappingType(pyObject2)) {
            throw Py.TypeError("locals must be a mapping");
        }
    }

    public static PyObject eval(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyCode pyCode;
        __builtin__.verify_mappings(pyObject2, pyObject3);
        if (pyObject instanceof PyCode) {
            pyCode = (PyCode)pyObject;
        } else if (pyObject instanceof PyString) {
            pyCode = (PyCode)CompileFunction.compile(pyObject, "<string>", "eval");
        } else {
            throw Py.TypeError("eval: argument 1 must be string or code object");
        }
        return Py.runCode(pyCode, pyObject3, pyObject2);
    }

    public static PyObject eval(PyObject pyObject, PyObject pyObject2) {
        return __builtin__.eval(pyObject, pyObject2, pyObject2);
    }

    public static PyObject eval(PyObject pyObject) {
        if (pyObject instanceof PyBaseCode && ((PyBaseCode)pyObject).hasFreevars()) {
            throw Py.TypeError("code object passed to eval() may not contain free variables");
        }
        return __builtin__.eval(pyObject, null, null);
    }

    public static void execfile(String string, PyObject pyObject, PyObject pyObject2) {
        __builtin__.execfile_flags(string, pyObject, pyObject2, Py.getCompilerFlags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execfile_flags(String string, PyObject pyObject, PyObject pyObject2, CompilerFlags compilerFlags) {
        PyCode pyCode;
        FileInputStream fileInputStream;
        __builtin__.verify_mappings(pyObject, pyObject2);
        try {
            fileInputStream = new FileInputStream(new RelativeFile(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw Py.IOError(fileNotFoundException);
        }
        try {
            pyCode = Py.compile_flags(fileInputStream, string, CompileMode.exec, compilerFlags);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw Py.IOError(iOException);
            }
        }
        Py.runCode(pyCode, pyObject2, pyObject);
    }

    public static void execfile(String string, PyObject pyObject) {
        __builtin__.execfile(string, pyObject, pyObject);
    }

    public static void execfile(String string) {
        __builtin__.execfile(string, null, null);
    }

    public static PyObject filter(PyObject pyObject, PyObject pyObject2) {
        if (pyObject2 instanceof PyString) {
            return __builtin__.filterBaseString(pyObject, (PyString)pyObject2, pyObject2 instanceof PyUnicode ? PyUnicode.TYPE : PyString.TYPE);
        }
        if (pyObject2 instanceof PyTuple) {
            return __builtin__.filterTuple(pyObject, (PyTuple)pyObject2);
        }
        PyList pyList = new PyList();
        for (PyObject pyObject3 : pyObject2.asIterable()) {
            if (pyObject == PyBoolean.TYPE || pyObject == Py.None ? !pyObject3.__nonzero__() : !pyObject.__call__(pyObject3).__nonzero__()) continue;
            pyList.append(pyObject3);
        }
        return pyList;
    }

    public static PyObject filterBaseString(PyObject pyObject, PyBaseString pyBaseString, PyType pyType) {
        if (pyObject == Py.None && pyBaseString.getType() == pyType) {
            return pyBaseString;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (PyObject pyObject2 : pyBaseString.asIterable()) {
            if (pyObject != Py.None ? !pyObject.__call__(pyObject2).__nonzero__() : !pyObject2.__nonzero__()) continue;
            if (!Py.isInstance(pyObject2, pyType)) {
                String string = pyType.fastGetName();
                throw Py.TypeError(String.format("can't filter %s to %s: __getitem__ returned different type", string, string));
            }
            stringBuilder.append(pyObject2.toString());
        }
        String string = stringBuilder.toString();
        return pyType == PyString.TYPE ? new PyString(string) : new PyUnicode(string);
    }

    public static PyObject filterTuple(PyObject pyObject, PyTuple pyTuple) {
        int n = pyTuple.size();
        if (n == 0) {
            if (pyTuple.getType() != PyTuple.TYPE) {
                return Py.EmptyTuple;
            }
            return pyTuple;
        }
        PyList pyList = new PyList();
        for (int i = 0; i < n; ++i) {
            PyObject pyObject2 = pyTuple.__finditem__(i);
            if (pyObject == Py.None ? !pyObject2.__nonzero__() : !pyObject.__call__(pyObject2).__nonzero__()) continue;
            pyList.append(pyObject2);
        }
        return PyTuple.fromIterable(pyList);
    }

    public static PyObject getattr(PyObject pyObject, PyObject pyObject2) {
        return __builtin__.getattr(pyObject, pyObject2, null);
    }

    public static PyObject getattr(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        String string = __builtin__.asName(pyObject2, "getattr");
        PyObject pyObject4 = null;
        PyException pyException = null;
        try {
            pyObject4 = pyObject.__findattr_ex__(string);
        }
        catch (PyException pyException2) {
            if (!pyException2.match(Py.AttributeError)) {
                throw pyException2;
            }
            pyException = pyException2;
        }
        if (pyObject4 != null) {
            return pyObject4;
        }
        if (pyObject3 != null) {
            return pyObject3;
        }
        if (pyException == null) {
            pyObject.noAttributeError(string);
        }
        throw pyException;
    }

    public static PyObject globals() {
        return Py.getFrame().f_globals;
    }

    public static boolean hasattr(PyObject pyObject, PyObject pyObject2) {
        String string = __builtin__.asName(pyObject2, "hasattr");
        try {
            return pyObject.__findattr__(string) != null;
        }
        catch (PyException pyException) {
            return false;
        }
    }

    public static PyInteger hash(PyObject pyObject) {
        return pyObject.__hash__();
    }

    public static PyString hex(PyObject pyObject) {
        return pyObject.__hex__();
    }

    public static long id(PyObject pyObject) {
        return Py.id(pyObject);
    }

    public static PyObject input(PyObject pyObject) {
        String string = __builtin__.raw_input(pyObject);
        return __builtin__.eval(new PyString(string));
    }

    public static PyObject input() {
        return __builtin__.input(new PyString(""));
    }

    public static PyString intern(PyObject pyObject) {
        if (!(pyObject instanceof PyString) || pyObject instanceof PyUnicode) {
            throw Py.TypeError("intern() argument 1 must be string, not " + pyObject.getType().fastGetName());
        }
        if (pyObject.getType() != PyString.TYPE) {
            throw Py.TypeError("can't intern subclass of string");
        }
        PyString pyString = (PyString)pyObject;
        String string = pyString.internedString();
        PyObject pyObject2 = internedStrings.__finditem__(string);
        if (pyObject2 != null) {
            return (PyString)pyObject2;
        }
        internedStrings.__setitem__(string, (PyObject)pyString);
        return pyString;
    }

    public static boolean isinstance(PyObject pyObject, PyObject pyObject2) {
        return Py.isInstance(pyObject, pyObject2);
    }

    public static boolean issubclass(PyObject pyObject, PyObject pyObject2) {
        return Py.isSubClass(pyObject, pyObject2);
    }

    public static PyObject iter(PyObject pyObject) {
        return pyObject.__iter__();
    }

    public static PyObject iter(PyObject pyObject, PyObject pyObject2) {
        return new PyCallIter(pyObject, pyObject2);
    }

    public static int len(PyObject pyObject) {
        return pyObject.__len__();
    }

    public static PyObject locals() {
        return Py.getFrame().getLocals();
    }

    public static PyObject map(PyObject[] pyObjectArray) {
        int n;
        int n2 = pyObjectArray.length - 1;
        if (n2 < 1) {
            throw Py.TypeError("map requires at least two arguments");
        }
        PyObject pyObject = pyObjectArray[0];
        PyList pyList = new PyList();
        PyObject[] pyObjectArray2 = new PyObject[n2];
        PyObject[] pyObjectArray3 = new PyObject[n2];
        for (n = 0; n < n2; ++n) {
            pyObjectArray3[n] = Py.iter(pyObjectArray[n + 1], "argument " + (n + 1) + " to map() must support iteration");
        }
        while (true) {
            n = 0;
            for (int i = 0; i < n2; ++i) {
                PyObject pyObject2 = pyObjectArray3[i].__iternext__();
                if (pyObject2 != null) {
                    pyObjectArray2[i] = pyObject2;
                    n = 1;
                    continue;
                }
                pyObjectArray2[i] = Py.None;
            }
            if (n == 0) break;
            if (pyObject == Py.None) {
                if (n2 == 1) {
                    pyList.append(pyObjectArray2[0]);
                    continue;
                }
                pyList.append(new PyTuple((PyObject[])pyObjectArray2.clone()));
                continue;
            }
            pyList.append(pyObject.__call__(pyObjectArray2));
        }
        return pyList;
    }

    public static PyString oct(PyObject pyObject) {
        return pyObject.__oct__();
    }

    public static final int ord(PyObject pyObject) {
        int n;
        PyString pyString = (PyString)pyObject;
        if (pyString instanceof PyUnicode) {
            n = pyString.getString().codePointCount(0, pyString.getString().length());
            if (n == 1) {
                return pyString.getString().codePointAt(0);
            }
        } else {
            n = pyString.getString().length();
            if (n == 1) {
                return pyString.getString().charAt(0);
            }
        }
        throw Py.TypeError("ord() expected a character, but string of length " + n + " found");
    }

    public static PyObject pow(PyObject pyObject, PyObject pyObject2) {
        return pyObject._pow(pyObject2);
    }

    private static boolean coerce(PyObject[] pyObjectArray) {
        PyObject pyObject = pyObjectArray[0];
        PyObject pyObject2 = pyObjectArray[1];
        PyObject[] pyObjectArray2 = pyObject._coerce(pyObject2);
        if (pyObjectArray2 != null) {
            pyObjectArray[0] = pyObjectArray2[0];
            pyObjectArray[1] = pyObjectArray2[1];
            return true;
        }
        pyObjectArray2 = pyObject2._coerce(pyObject);
        if (pyObjectArray2 != null) {
            pyObjectArray[0] = pyObjectArray2[1];
            pyObjectArray[1] = pyObjectArray2[0];
            return true;
        }
        return false;
    }

    public static PyObject pow(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyObject pyObject4;
        if (pyObject3 == Py.None) {
            return __builtin__.pow(pyObject, pyObject2);
        }
        PyObject[] pyObjectArray = new PyObject[]{pyObject, pyObject2};
        if (__builtin__.coerce(pyObjectArray)) {
            pyObject = pyObjectArray[0];
            pyObject2 = pyObjectArray[1];
            pyObjectArray[1] = pyObject3;
            if (__builtin__.coerce(pyObjectArray)) {
                pyObject = pyObjectArray[0];
                pyObject3 = pyObjectArray[1];
                pyObjectArray[0] = pyObject2;
                if (__builtin__.coerce(pyObjectArray)) {
                    pyObject3 = pyObjectArray[1];
                    pyObject2 = pyObjectArray[0];
                }
            }
        } else {
            pyObjectArray[1] = pyObject3;
            if (__builtin__.coerce(pyObjectArray)) {
                pyObject = pyObjectArray[0];
                pyObject3 = pyObjectArray[1];
                pyObjectArray[0] = pyObject2;
                if (__builtin__.coerce(pyObjectArray)) {
                    pyObject2 = pyObjectArray[0];
                    pyObject3 = pyObjectArray[1];
                    pyObjectArray[1] = pyObject;
                    if (__builtin__.coerce(pyObjectArray)) {
                        pyObject = pyObjectArray[1];
                        pyObject2 = pyObjectArray[0];
                    }
                }
            }
        }
        if ((pyObject4 = pyObject.__pow__(pyObject2, pyObject3)) != null) {
            return pyObject4;
        }
        throw Py.TypeError(String.format("unsupported operand type(s) for pow(): '%.100s', '%.100s', '%.100s'", pyObject.getType().fastGetName(), pyObject2.getType().fastGetName(), pyObject3.getType().fastGetName()));
    }

    public static PyObject range(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        try {
            n = pyObject.asInt();
            n2 = pyObject2.asInt();
            n3 = pyObject3.asInt();
        }
        catch (PyException pyException) {
            return __builtin__.handleRangeLongs(pyObject, pyObject2, pyObject3);
        }
        if (n3 == 0) {
            throw Py.ValueError("range() step argument must not be zero");
        }
        int n4 = n3 > 0 ? PyXRange.getLenOfRange(n, n2, n3) : PyXRange.getLenOfRange(n2, n, -n3);
        if (n4 < 0) {
            throw Py.OverflowError("range() result has too many items");
        }
        PyObject[] pyObjectArray = new PyObject[n4];
        int n5 = 0;
        while (n5 < n4) {
            pyObjectArray[n5] = Py.newInteger(n);
            ++n5;
            n += n3;
        }
        return new PyList(pyObjectArray);
    }

    public static PyObject range(PyObject pyObject) {
        return __builtin__.range(Py.Zero, pyObject, Py.One);
    }

    public static PyObject range(PyObject pyObject, PyObject pyObject2) {
        return __builtin__.range(pyObject, pyObject2, Py.One);
    }

    private static PyObject handleRangeLongs(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (!(pyObject instanceof PyInteger) && !(pyObject instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer start argument expected, got %s.", pyObject.getType().fastGetName()));
        }
        if (!(pyObject2 instanceof PyInteger) && !(pyObject2 instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer end argument expected, got %s.", pyObject2.getType().fastGetName()));
        }
        if (!(pyObject3 instanceof PyInteger) && !(pyObject3 instanceof PyLong)) {
            throw Py.TypeError(String.format("range() integer step argument expected, got %s.", pyObject3.getType().fastGetName()));
        }
        int n = pyObject3._cmp(Py.Zero);
        if (n == 0) {
            throw Py.ValueError("range() step argument must not be zero");
        }
        int n2 = n > 0 ? __builtin__.getLenOfRangeLongs(pyObject, pyObject2, pyObject3) : __builtin__.getLenOfRangeLongs(pyObject2, pyObject, pyObject3.__neg__());
        if (n2 < 0) {
            throw Py.OverflowError("range() result has too many items");
        }
        PyObject[] pyObjectArray = new PyObject[n2];
        for (int i = 0; i < n2; ++i) {
            pyObjectArray[i] = pyObject.__long__();
            pyObject = pyObject.__add__(pyObject3);
        }
        return new PyList(pyObjectArray);
    }

    private static int getLenOfRangeLongs(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (pyObject._cmp(pyObject2) >= 0) {
            return 0;
        }
        try {
            PyObject pyObject4 = pyObject2.__sub__(pyObject).__sub__(Py.One);
            PyObject pyObject5 = pyObject4.__floordiv__(pyObject3).__add__(Py.One);
            return pyObject5.asInt();
        }
        catch (PyException pyException) {
            return -1;
        }
    }

    private static PyString readline(PyObject pyObject) {
        if (pyObject instanceof PyFile) {
            return ((PyFile)pyObject).readline();
        }
        PyObject pyObject2 = pyObject.invoke("readline");
        if (!(pyObject2 instanceof PyString)) {
            throw Py.TypeError("object.readline() returned non-string");
        }
        return (PyString)pyObject2;
    }

    public static String raw_input(PyObject pyObject, PyObject pyObject2) {
        PyObject pyObject3 = Py.getSystemState().stdout;
        if (pyObject3 instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("[raw_]input: lost sys.stdout");
        }
        Py.print(pyObject3, pyObject);
        String string = __builtin__.readline(pyObject2).toString();
        if (string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            throw Py.EOFError("raw_input()");
        }
        return string;
    }

    public static String raw_input(PyObject pyObject) {
        PyObject pyObject2 = Py.getSystemState().stdin;
        if (pyObject2 instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("[raw_]input: lost sys.stdin");
        }
        return __builtin__.raw_input(pyObject, pyObject2);
    }

    public static String raw_input() {
        return __builtin__.raw_input(new PyString(""));
    }

    public static PyObject reduce(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        PyObject pyObject4;
        PyObject pyObject5 = pyObject3;
        PyObject pyObject6 = Py.iter(pyObject2, "reduce() arg 2 must support iteration");
        while ((pyObject4 = pyObject6.__iternext__()) != null) {
            if (pyObject5 == null) {
                pyObject5 = pyObject4;
                continue;
            }
            pyObject5 = pyObject.__call__(pyObject5, pyObject4);
        }
        if (pyObject5 == null) {
            throw Py.TypeError("reduce of empty sequence with no initial value");
        }
        return pyObject5;
    }

    public static PyObject reduce(PyObject pyObject, PyObject pyObject2) {
        return __builtin__.reduce(pyObject, pyObject2, null);
    }

    public static PyObject reload(PyModule pyModule) {
        return imp.reload(pyModule);
    }

    public static PyObject reload(PySystemState pySystemState) {
        pySystemState.reload();
        return pySystemState;
    }

    public static PyString repr(PyObject pyObject) {
        return pyObject.__repr__();
    }

    public static void setattr(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        pyObject.__setattr__(__builtin__.asName(pyObject2, "setattr"), pyObject3);
    }

    public static PyObject sum(PyObject pyObject, PyObject pyObject2) {
        if (pyObject2 instanceof PyString) {
            throw Py.TypeError("sum() can't sum strings [use ''.join(seq) instead]");
        }
        for (PyObject pyObject3 : pyObject.asIterable()) {
            pyObject2 = pyObject2._add(pyObject3);
        }
        return pyObject2;
    }

    public static PyObject reversed(PyObject pyObject) {
        if (pyObject.__findattr__("__getitem__") != null && pyObject.__findattr__("__len__") != null && pyObject.__findattr__("keys") == null) {
            return new PyReversedIterator(pyObject);
        }
        throw Py.TypeError("argument to reversed() must be a sequence");
    }

    public static PyObject sum(PyObject pyObject) {
        return __builtin__.sum(pyObject, Py.Zero);
    }

    public static PyType type(PyObject pyObject) {
        return pyObject.getType();
    }

    public static PyObject vars() {
        return __builtin__.locals();
    }

    public static PyObject vars(PyObject pyObject) {
        try {
            return pyObject.__getattr__("__dict__");
        }
        catch (PyException pyException) {
            if (pyException.match(Py.AttributeError)) {
                throw Py.TypeError("vars() argument must have __dict__ attribute");
            }
            throw pyException;
        }
    }

    public static PyObject zip() {
        return new PyList();
    }

    public static PyObject zip(PyObject[] pyObjectArray) {
        int n = pyObjectArray.length;
        PyObject[] pyObjectArray2 = new PyObject[n];
        for (int i = 0; i < n; ++i) {
            PyObject pyObject = pyObjectArray[i].__iter__();
            if (pyObject == null) {
                throw Py.TypeError("zip argument #" + (i + 1) + " must support iteration");
            }
            pyObjectArray2[i] = pyObject;
        }
        PyList pyList = new PyList();
        int n2 = 0;
        while (true) {
            PyObject[] pyObjectArray3 = new PyObject[n];
            for (int i = 0; i < n; ++i) {
                PyObject pyObject;
                try {
                    pyObject = pyObjectArray2[i].__iternext__();
                }
                catch (PyException pyException) {
                    if (pyException.match(Py.StopIteration)) {
                        return pyList;
                    }
                    throw pyException;
                }
                if (pyObject == null) {
                    return pyList;
                }
                pyObjectArray3[i] = pyObject;
            }
            pyList.append(new PyTuple(pyObjectArray3));
            ++n2;
        }
    }

    public static PyObject __import__(String string) {
        return __builtin__.__import__(string, null, null, null, -1);
    }

    public static PyObject __import__(String string, PyObject pyObject) {
        return __builtin__.__import__(string, pyObject, null, null, -1);
    }

    public static PyObject __import__(String string, PyObject pyObject, PyObject pyObject2) {
        return __builtin__.__import__(string, pyObject, pyObject2, null, -1);
    }

    public static PyObject __import__(String string, PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        return __builtin__.__import__(string, pyObject, pyObject2, pyObject3, -1);
    }

    public static PyObject __import__(String string, PyObject pyObject, PyObject pyObject2, PyObject pyObject3, int n) {
        PyFrame pyFrame = Py.getFrame();
        PyObject pyObject4 = pyFrame != null && pyFrame.f_builtins != null ? pyFrame.f_builtins : PySystemState.builtins;
        PyObject pyObject5 = pyObject4.__finditem__("__import__");
        if (pyObject5 == null) {
            return null;
        }
        PyObject[] pyObjectArray = n < 0 ? new PyObject[]{Py.newString(string), pyObject, pyObject2, pyObject3} : new PyObject[]{Py.newString(string), pyObject, pyObject2, pyObject3, Py.newInteger(n)};
        PyObject pyObject6 = pyObject5.__call__(pyObjectArray);
        return pyObject6;
    }

    private static String asName(PyObject pyObject, String string) {
        if (pyObject instanceof PyUnicode) {
            return ((PyUnicode)pyObject).encode().intern();
        }
        if (pyObject instanceof PyString) {
            return ((PyString)pyObject).internedString();
        }
        throw Py.TypeError(string + "(): attribute name must be string");
    }
}

